#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include "tinySHT2x.h"
#include <Bounce2.h>
#include <LEDStripDriver.h>
#include <WiFi.h>
#include <PubSubClient.h>

#define SCREEN_WIDTH 128 
#define SCREEN_HEIGHT 64  

#define OLED_RESET    -1

#define DOOR_PIN 27
#define BUTTON_PIN 22
#define BUTTON2_PIN 15
#define FAN_PIN 12


const char* ssid = "LAPTOP-2ITOPBVG_1228";
const char* password = "6w31J98+";
const char* mqtt_server = "test.mosquitto.org";
WiFiClient espClient;
PubSubClient client(espClient);
tinySHT2x sht;
const char* topic_FAN;
const char* topic_TEMPERATURE;
const char* topic_HUMIDITY;

void setup_wifi() {
    Serial.println();
    Serial.print("Connecting to ");
    Serial.println(ssid);
    WiFi.begin(ssid, password);

    while (WiFi.status() != WL_CONNECTED) {
        delay(500);
        Serial.print(".");
    }

    Serial.println("");
    Serial.println("WiFi connected");
    Serial.println("IP address: ");
    Serial.println(WiFi.localIP());
}

void reconnect() {
    while (!client.connected()) {
        Serial.print("Attempting MQTT connection...");
        if (client.connect("ESP32Client")) {
            Serial.println("connected");
            break;
        } else {
            Serial.print("failed, rc=");
            Serial.print(client.state());
            Serial.println(" try again in 5 seconds");
            delay(5000);
        }
    }
}




Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);
tinySHT2x sht;
LEDStripDriver led = LEDStripDriver(33, 32);
enum MenuState {
  MENU_HUMIDITY,
  MENU_TEMPERATURE,
  MENU_DOORCONTACT,
  MENU_FAN
};

MenuState currentMenu = MENU_HUMIDITY;
Bounce debouncer = Bounce();
void setup() {
  Serial.begin(115200);
  client.setServer(mqtt_server, 1883);
  setup_wifi();  
  pinMode(BUTTON_PIN, INPUT_PULLUP);
  pinMode(DOOR_PIN,INPUT_PULLUP);
  Wire.begin(5,4);
  if(!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) { 
    Serial.println(F("SSD1306 allocation failed"));
    for(;;);
  }
  display.clearDisplay();
  sht.begin();
  pinMode(FAN_PIN, OUTPUT);
  pinMode(BUTTON2_PIN, INPUT_PULLUP);
  debouncer.attach(BUTTON2_PIN);
  debouncer.interval(50);
}
int state=0;
  static unsigned long lastDebounceTime = 0;
  static const unsigned long debounceDelay = 50;
  static int lastButtonState = HIGH;
  int currentfanstate;
  String Door_print;
  String Fan_print;
void loop() {
  if (!client.connected()) {
    reconnect();
  }
  client.loop();
  float temperature = sht.getTemperature();
  float humidity = sht.getHumidity();
  
  String tempStr = String(temperature, 1);
  String humStr = String(humidity, 1);
  

  client.publish("HT/temperature", tempStr.c_str());
  client.publish("HT/humidity", humStr.c_str()); 
  
  
  int buttonState = digitalRead(BUTTON_PIN);
  int doorstate = digitalRead(DOOR_PIN);
  int button2State = digitalRead(BUTTON2_PIN);
  debouncer.update();
    if (buttonState == LOW) {
      switch (currentMenu) {
        case MENU_HUMIDITY:
          currentMenu = MENU_TEMPERATURE;
          break;
        case MENU_TEMPERATURE:
          currentMenu = MENU_DOORCONTACT;
          break;
        case MENU_DOORCONTACT:
          currentMenu = MENU_FAN;
          currentfanstate = state;
          break;
        case MENU_FAN:
          state = currentfanstate;
          currentMenu = MENU_HUMIDITY;
          break;           
      }
      delay(100);
    }
    if(doorstate==LOW){
      Door_print = "CLOSED";
    }else{
      Door_print = "OPEN";
      }
  if(currentMenu == MENU_FAN){
  if (debouncer.fell()) {
    // Toggle the state
    state = !state;
     }
  }
  if(currentMenu == MENU_DOORCONTACT){
  if (doorstate==HIGH) {
    led.setColor(255, 0, 0);
    delay(100);
    led.setColor(0, 0, 0);
      }
  }
  if(state){
    digitalWrite(FAN_PIN,HIGH);
    Fan_print = "ON";
    led.setColor(0, 0, 255);
  }else{
    digitalWrite(FAN_PIN,LOW);
    Fan_print = "OFF";
    led.setColor(255, 255, 255);
    
    }

  display.clearDisplay();
  display.setTextSize(3);
  display.setTextColor(SSD1306_WHITE);
  display.setCursor(0, 10);

  switch (currentMenu) {
    case MENU_HUMIDITY:
      display.println("Hum:   " + String(sht.getHumidity(), 1) + " %");
      break;
    case MENU_TEMPERATURE:
      display.println("Temp:  " + String(sht.getTemperature(), 1) + " C");
      break;
    case MENU_DOORCONTACT:
      display.println("Door :  "+Door_print);
      break;
    case MENU_FAN:
      display.println("FAN:   "+Fan_print);
      break;      
  }
  Serial.println(state);
  display.display();
  delay(100);
}
